<?php
session_start();
if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

include('../config/db_connect.php');
$message = "";

if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $dept_name = trim($_POST['dept_name']);

    if(!empty($dept_name)){
        $stmt = $conn->prepare("INSERT INTO departments (dept_name) VALUES (?)");
        $stmt->bind_param("s", $dept_name);

        if($stmt->execute()){
            $message = "✅ Department added successfully!";
        } else {
            $message = "❌ Department already exists!";
        }
    } else {
        $message = "⚠️ Please enter department name.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Add Department</title>
<style>
    body{ margin:0; font-family:Poppins,Arial; background:#f5f7ff; display:flex; justify-content:center; align-items:center; height:100vh; }
    .box{
        background:white; padding:30px; width:360px;
        border-radius:10px; box-shadow:0 6px 20px rgba(0,0,0,0.1); text-align:center;
    }
    input,button{
        width:100%; padding:12px; margin:10px 0; border-radius:8px;
        border:1px solid #ccc; font-size:16px;
    }
    button{
        background:#4c1d95; color:white; border:none; cursor:pointer;
        transition:0.3s;
    }
    button:hover{ background:#3a1672; }
    .msg{ font-size:14px; margin-top:10px; font-weight:bold; }
    a{ text-decoration:none; color:#4c1d95; font-weight:bold; }
</style>
</head>

<body>
<div class="box">
    <h2>Add Department</h2>

    <form method="POST">
        <input type="text" name="dept_name" placeholder="Enter Department Name" required>
        <button type="submit">Save</button>
    </form>

    <?php if($message){ echo "<p class='msg'>$message</p>"; } ?>

    <a href="dashboard.php">⬅ Back</a>
</div>
</body>
</html>
