<?php
session_start();
include('../config/db_connect.php');

// Redirect if not logged in
if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

$message = "";

// Handle form submit
if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $subject_name = trim($_POST['subject_name']);

    if($subject_name){
        // Secure insert
        $stmt = $conn->prepare("INSERT INTO subjects (subject_name) VALUES (?)");
        $stmt->bind_param("s", $subject_name);

        if($stmt->execute()){
            $message = "✅ Subject added successfully!";
        } else {
            $message = "❌ Error adding subject!";
        }

        $stmt->close();
    } else {
        $message = "⚠️ Subject name cannot be empty!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Subject</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #075d8a, #0a9edb);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            background: rgba(255,255,255,0.15);
            backdrop-filter: blur(12px);
            padding: 35px;
            border-radius: 12px;
            width: 420px;
            text-align: center;
            color: #fff;
        }

        h2 { margin-bottom: 20px; }

        input {
            width: 90%;
            padding: 10px;
            border-radius: 6px;
            border: none;
            outline: none;
            margin-top: 12px;
            font-size: 15px;
        }

        button {
            width: 95%;
            padding: 12px;
            margin-top: 25px;
            background: #fff;
            border-radius: 6px;
            border: none;
            color: #075d8a;
            font-weight: bold;
            cursor: pointer;
            transition: 0.3s;
        }

        button:hover { background: #e7e7e7; }

        .message {
            margin-top: 15px;
            font-size: 14px;
            font-weight: bold;
        }

        a {
            display: inline-block;
            margin-top: 25px;
            color: #fff;
            opacity: 0.85;
            text-decoration: none;
        }

        a:hover { opacity: 1; }
    </style>
</head>
<body>

<div class="container">
    <h2>Add Subject</h2>

    <form method="POST">
        <input type="text" name="subject_name" placeholder="Enter Subject Name" required>
        <button type="submit">➕ Save Subject</button>
    </form>

    <?php if($message){ ?>
        <p class="message"><?php echo $message; ?></p>
    <?php } ?>

    <a href="dashboard.php">⬅ Back to Dashboard</a>
</div>

</body>
</html>
