<?php
// admin/admin_view_reports.php
session_start();
include('../config/db_connect.php');

if (!isset($_SESSION['admin'])) {
    header("Location: index.php");
    exit;
}

// Selected class and term from GET
$class_id = isset($_GET['class_id']) ? (int)$_GET['class_id'] : 0;
$term = isset($_GET['term']) ? $_GET['term'] : "Term 1";

// Fetch classes for dropdown
$classes = mysqli_query($conn, "SELECT * FROM classes ORDER BY class_name ASC");

// grading function
function grade_info($m){
    if($m >= 75) return ["1","DISTINCTION"];
    if($m >= 70) return ["2","DISTINCTION"];
    if($m >= 65) return ["3","MERIT"];
    if($m >= 60) return ["4","MERIT"];
    if($m >= 55) return ["5","CREDIT"];
    if($m >= 50) return ["6","CREDIT"];
    if($m >= 45) return ["7","SATISFACTORY"];
    if($m >= 40) return ["8","SATISFACTORY"];
    return ["9","UNSATISFACTORY"];
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Admin — View Report Cards</title>
<style>
    body{font-family: Arial, sans-serif; background:#fff; color:#111; margin:20px;}
    .container { max-width: 980px; margin: auto; }
    header{display:flex;justify-content:space-between;align-items:center;margin-bottom:16px;}
    select, button { padding:6px 10px; margin-right:8px; font-size:14px; }
    .page{max-width:800px;margin:18px auto;border:1px solid #ddd;padding:18px;page-break-after:always;}
    .header{display:flex;align-items:center;justify-content:space-between;margin-bottom:14px;}
    .school-title{text-align:center;}
    h1{margin:0;font-size:20px;}
    .sub{font-size:13px;margin-top:4px;}
    .meta{display:flex;justify-content:space-between;margin-top:17px;}
    .meta div{width:56%;}
    table{width:100%;border-collapse:collapse;margin-top:12px;}
    th,td{border:1px solid #000;padding:6px;text-align:center;font-size:13px;}
    th{background:#dff0d8;}
    .signs{display:flex;justify-content:space-between;margin-top:18px;}
    .sign-box{width:30%;text-align:center;}
    .sign-line{border:1px solid #000;height:60px;margin-bottom:6px;}
    .print-btn{background:#075d8a;color:#fff;padding:8px 12px;border:none;border-radius:6px;cursor:pointer;}
    @media print{ .print-btn, .no-print{display:none} }
    .no-results{color:#b00;margin-top:12px;}
</style>
</head>
<body>
<div class="container">
<header>
    <div>
        <h2>Admin — View Report Cards</h2>
        <small>Generate printable report cards for a selected class and term</small>
    </div>

    <div class="no-print">
        <form method="get" style="display:inline;">
            <label><strong>Class:</strong></label>
            <select name="class_id" required>
                <option value="">-- Select Class --</option>
                <?php while($c = mysqli_fetch_assoc($classes)): ?>
                    <option value="<?php echo (int)$c['class_id']; ?>" <?php if($class_id == (int)$c['class_id']) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($c['class_name']); ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <label><strong>Term:</strong></label>
            <select name="term">
                <option value="Term 1" <?php if($term=="Term 1") echo "selected"; ?>>Term 1</option>
                <option value="Term 2" <?php if($term=="Term 2") echo "selected"; ?>>Term 2</option>
                <option value="Term 3" <?php if($term=="Term 3") echo "selected"; ?>>Term 3</option>
            </select>

            <button type="submit">View</button>
        </form>

        <?php if($class_id): ?>
            <button class="print-btn" onclick="window.print()">🖨️ Print All</button>
        <?php endif; ?>
    </div>
</header>

<?php
if (!$class_id) {
    echo "<p class='no-results'>Please select a class to view report cards.</p>";
    echo "</div></body></html>";
    exit;
}

// Fetch class & teacher
$class_row = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM classes WHERE class_id = {$class_id} LIMIT 1"));
$className = $class_row ? $class_row['class_name'] : 'Unknown Class';

$teacher_row = mysqli_fetch_assoc(mysqli_query($conn, "SELECT full_name FROM teachers WHERE class_id = {$class_id} LIMIT 1"));
$teacherName = $teacher_row ? $teacher_row['full_name'] : 'N/A';

// Fetch students
$students_q = mysqli_query($conn, "SELECT * FROM students WHERE class_id = {$class_id} ORDER BY full_name ASC");
$total_students = mysqli_num_rows($students_q);

if ($total_students == 0) {
    echo "<p class='no-results'>No students found in {$className}.</p>";
    echo "</div></body></html>";
    exit;
}

// Ranking calculations
$averages = [];
$students = [];

while($s = mysqli_fetch_assoc($students_q)){
    $students[] = $s;
    $sid = (int)$s['student_id'];

    $avg_row = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT AVG(IFNULL(mark,0)) AS avgMark 
        FROM marks 
        WHERE student_id={$sid} AND term='".mysqli_real_escape_string($conn,$term)."'
    "));

    $avg = ($avg_row && $avg_row['avgMark'] !== null) ? round($avg_row['avgMark'],2) : 0;
    $averages[$sid] = $avg;
}

// SORT + RANK
arsort($averages);

$ranks = [];
$rank = 1;
$prevAvg = null;
$skip = 0;

foreach($averages as $sid => $avg){
    if ($prevAvg === null) {
        $ranks[$sid] = $rank;
    } else {
        if ($avg == $prevAvg) {
            $ranks[$sid] = $rank;
            $skip++;
        } else {
            $rank = $rank + $skip + 1;
            $ranks[$sid] = $rank;
            $skip = 0;
        }
    }
    $prevAvg = $avg;
}

// ⭐ SAVE RANKS INTO DATABASE
foreach($ranks as $sid => $rpos){
    mysqli_query($conn, "
        UPDATE marks 
        SET rank_position={$rpos}
        WHERE student_id={$sid} AND term='".mysqli_real_escape_string($conn,$term)."'
    ");
}

// =====================================
//        RENDER REPORT CARDS
// =====================================
foreach($students as $student){
    $student_id = (int)$student['student_id'];
    $rank_position = $ranks[$student_id];

    $marks_q = mysqli_query($conn, "
        SELECT sub.subject_name, m.mark
        FROM marks m
        LEFT JOIN subjects sub ON m.subject_id = sub.subject_id
        WHERE m.student_id = {$student_id} AND m.term = '".mysqli_real_escape_string($conn,$term)."'
        ORDER BY sub.subject_name ASC
    ");

    $stats = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT AVG(IFNULL(mark,0)) AS avgMark, SUM(IF(mark>=40,1,0)) AS passedCount, COUNT(*) AS subjCount
        FROM marks
        WHERE student_id = {$student_id} AND term = '".mysqli_real_escape_string($conn,$term)."'
    "));

    $average = round($stats['avgMark'],2);
    $passedCount = (int)$stats['passedCount'];
    $subjCount = (int)$stats['subjCount'];

    if($passedCount == 0) $comment = "Poor performance. Needs serious improvement.";
    elseif($passedCount <= 2) $comment = "Below average performance. More commitment required.";
    elseif($passedCount <= 4) $comment = "Fair performance. Encourage more effort.";
    elseif($passedCount <= 6) $comment = "Good performance. Keep it up.";
    elseif($passedCount <= 8) $comment = "Very good performance. Continue maintaining this level.";
    else $comment = "Excellent performance! Outstanding achievement.";
?>
    <div class="page">
        <div class="header">
            <div class="school-title">
                <h1>DIVINE PROVIDENCE CONVENT SCHOOL</h1>
                <div class="sub">P.O BOX 214, CHAWAMA - LUSAKA · PHONE: +260 773398030</div>
                <div style="margin-top:8px;font-weight:bold;">REPORT CARD - <?php echo htmlspecialchars($term); ?></div>
            </div>
        </div>

        <table class="meta" style="width:100%; border:none; margin-top:8px;">
            <tr>
                <td style="border:none; text-align:left;"><strong>Pupil's Name:</strong> <?php echo htmlspecialchars($student['full_name']); ?></td>
                <td style="border:none; text-align:left;"><strong>Gender:</strong> <?php echo htmlspecialchars($student['gender']); ?></td>
            </tr>
            <tr>
                <td style="border:none; text-align:left;"><strong>Class:</strong> <?php echo htmlspecialchars($className); ?></td>
                <td style="border:none; text-align:left;"><strong>Class Teacher:</strong> <?php echo htmlspecialchars($teacherName); ?></td>
            </tr>
            <tr>
                <td style="border:none; text-align:left;"><strong>Date:</strong> <?php echo date("d/m/Y"); ?></td>
                <td style="border:none; text-align:left;"><strong>Position:</strong> <?php echo "{$rank_position} out of {$total_students}"; ?></td>
            </tr>
        </table>

        <table>
            <thead>
                <tr>
                    <th>SUBJECT</th>
                    <th>TOTAL MARKS</th>
                    <th>MARKS OBTAINED (%)</th>
                    <th>GRADE</th>
                    <th>STANDARD</th>
                </tr>
            </thead>
            <tbody>
            <?php
                $count = 0;
                while($r = mysqli_fetch_assoc($marks_q)){
                    $count++;
                    $mval = is_null($r['mark']) ? 0 : (int)$r['mark'];
                    list($g, $std) = grade_info($mval);

                    echo "<tr>
                            <td style='text-align:left;padding-left:8px;'>".htmlspecialchars(strtoupper($r['subject_name']))."</td>
                            <td>100</td>
                            <td>{$mval}</td>
                            <td>{$g}</td>
                            <td>{$std}</td>
                          </tr>";
                }

                if($count === 0){
                    echo "<tr><td colspan='5'>No marks recorded for this term.</td></tr>";
                }
            ?>
            </tbody>
        </table>

        <div style="margin-top:12px;">
            <strong>AVERAGE MARK:</strong> <?php echo $average; ?>% &nbsp;&nbsp;&nbsp;
            <strong>SUBJECTS PASSED:</strong> <?php echo $passedCount; ?>/<?php echo $subjCount; ?> &nbsp;&nbsp;&nbsp;
            <strong>CLASS POSITION:</strong> <?php echo "{$rank_position} out of {$total_students}"; ?>
        </div>

        <h4 style="margin-top:14px;">PERFORMANCE COMMENT:</h4>
        <p><?php echo htmlspecialchars($comment); ?></p>

        <div class="signs">
            <div class="sign-box">
                <div class="sign-line"></div>
                <div>Class Teacher</div>
                <div style="margin-top:6px;"><?php echo htmlspecialchars($teacherName); ?></div>
            </div>
            <div class="sign-box">
                <div class="sign-line"></div>
                <div>Deputy Head</div>
                <div style="margin-top:6px;">Mr Tembo</div>
            </div>
            <div class="sign-box">
                <div class="sign-line"></div>
                <div>Parent / Guardian</div>
            </div>
        </div>
    </div>

<?php
} // end foreach
?>
</div>
</body>
</html>
