<?php
session_start();
include('../config/db_connect.php');

// Ensure admin is logged in
if (!isset($_SESSION['admin'])) {
    header("Location: index.php");
    exit;
}

// Check if an ID was passed
if (!isset($_GET['id'])) {
    header("Location: dashboard.php?msg=No+teacher+selected");
    exit;
}

$teacher_id = intval($_GET['id']); // prevent SQL injection

// Delete the teacher
$stmt = $conn->prepare("DELETE FROM teachers WHERE teacher_id = ?");
$stmt->bind_param("i", $teacher_id);

if ($stmt->execute()) {
    header("Location: dashboard.php?msg=Teacher+deleted+successfully");
} else {
    header("Location: dashboard.php?msg=Failed+to+delete+teacher");
}

$stmt->close();
$conn->close();
?>
