<?php
session_start();
include('../config/db_connect.php');

function calc_napsa($salary){ return round($salary * 0.05,2); }
function calc_nhima($salary){ return round($salary * 0.01,2); }

function calc_paye($salary){
    if ($salary <= 4800) return 0;
    if ($salary <= 6800) return round(($salary - 4800) * 0.25,2);
    if ($salary <= 8900) return round(500 + ($salary - 6800) * 0.30,2);
    return round(1130 + ($salary - 8900) * 0.37,2);
}

$employees = mysqli_query($conn,"SELECT * FROM payroll_employees");

if(isset($_POST['generate'])){
    $emp_id   = $_POST['emp_id'];
    $basic    = $_POST['basic'];
    $allow    = $_POST['allowance'];
    $month    = $_POST['month'];
    $year     = date("Y");

    $gross = $basic + $allow;

    $napsa = calc_napsa($gross);
    $nhima = calc_nhima($gross);
    $paye  = calc_paye($gross);

    $net = $gross - ($napsa + $nhima + $paye);

    mysqli_query($conn,"INSERT INTO payroll_records 
      (emp_id,basic_salary,allowance,month,year,napsa,nhima,paye,net_pay)
      VALUES('$emp_id','$basic','$allow','$month','$year','$napsa','$nhima','$paye','$net')");

    $new_id = mysqli_insert_id($conn);

    header("Location: print_payslip.php?id=$new_id");
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Generate Payroll</title>
<style>
body { font-family:arial; background:#f4f6f9; }
.card{background:#fff;padding:20px;width:450px;margin:auto;border-radius:10px;}
input,select{width:100%;padding:8px;margin-bottom:10px;}
button{padding:10px;width:100%;background:#1e40af;color:#fff;border:0;}
</style>
</head>
<body>

<div class="card">
<h2>Generate Payroll</h2>

<form method="POST">
<select name="emp_id" required>
<option value="">Select Employee</option>
<?php while($e=mysqli_fetch_assoc($employees)): ?>
<option value="<?= $e['emp_id'] ?>">
<?= $e['full_name'] ?>
</option>
<?php endwhile; ?>
</select>

<input type="number" name="basic" placeholder="Basic Salary" required>
<input type="number" name="allowance" placeholder="Allowances">

<select name="month">
<option>January</option><option>February</option><option>March</option>
<option>April</option><option>May</option><option>June</option>
<option>July</option><option>August</option><option>September</option>
<option>October</option><option>November</option><option>December</option>
</select>

<button name="generate">Generate Payslip</button>
</form>

</div>

</body>
</html>
