<?php
include('../config/db_connect.php');
include('amountToWords.php');

$id = (int)$_GET['id'];

$row = mysqli_fetch_assoc(mysqli_query($conn,"
SELECT p.*, e.*
FROM payroll p
JOIN employees e ON e.employee_id = p.employee_id
WHERE p.payroll_id = $id
LIMIT 1
"));
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Payslip</title>

<style>
body{font-family:Arial;background:#fff;}
.payslip{
    width:800px;
    margin:auto;
    border:1px solid #000;
    padding:15px;
}

.header{
    text-align:center;
    font-weight:bold;
}

.logo{
    float:right;
    width:80px;
}

.row{display:flex;justify-content:space-between;}

table{
    width:100%;
    border-collapse:collapse;
}

th,td{
    border:1px solid #000;
    padding:5px;
    font-size:14px;
}
</style>
</head>

<body>

<div class="payslip">

<img src="../assets/logo.png" class="logo">

<div class="header">
    <h2>ZAMBIA PAYROLL SYSTEM</h2>
    <p>Payslip for <?php echo $row['month_year']; ?></p>
</div>

<br>

<div class="row">
<div>
<b>Name:</b> <?php echo $row['full_name']; ?><br>
<b>Department:</b> <?php echo $row['department']; ?><br>
<b>Designation:</b> <?php echo $row['designation']; ?>
</div>

<div>
<b>Bank:</b> <?php echo $row['bank_name']; ?><br>
<b>A/C:</b> <?php echo $row['account_number']; ?><br>
<b>TPIN:</b> <?php echo $row['tpin']; ?>
</div>
</div>

<br>

<table>
<tr>
<th>Earnings</th><th>Amount</th>
<th>Deductions</th><th>Amount</th>
</tr>

<tr>
<td>Basic Salary</td>
<td><?php echo number_format($row['basic_salary'],2); ?></td>

<td>NAPSA</td>
<td><?php echo number_format($row['napsa'],2); ?></td>
</tr>

<tr>
<td>Allowances</td>
<td><?php echo number_format($row['allowances'],2); ?></td>

<td>NHIMA</td>
<td><?php echo number_format($row['nhima'],2); ?></td>
</tr>

<tr>
<td></td><td></td>
<td>PAYE</td>
<td><?php echo number_format($row['paye'],2); ?></td>
</tr>

<tr>
<td></td><td></td>
<td>Other</td>
<td><?php echo number_format($row['other_deductions'],2); ?></td>
</tr>

<tr>
<th>Total</th>
<th><?php echo number_format($row['total_earnings'],2); ?></th>

<th>Total</th>
<th><?php echo number_format($row['total_deductions'],2); ?></th>
</tr>

<tr>
<th colspan="3">NET PAY</th>
<th><?php echo number_format($row['net_pay'],2); ?></th>
</tr>
</table>

<br>
<b>Net Salary in words:</b><br>
<?php echo amountToWords(round($row['net_pay'])); ?>

<br><br>

<p>_______________________ &nbsp; Employer Signature</p>
<p>_______________________ &nbsp; Employee Signature</p>

</div>

<br>

<center>
<button onclick="window.print()">🖨 PRINT</button>
</center>

</body>
</html>
