<?php
session_start();
include('../config/db_connect.php');

$res = $conn->query("
    SELECT h.*, d.dept_name 
    FROM hod_uploads h
    LEFT JOIN departments d ON d.dept_name = h.department
    ORDER BY upload_date DESC
");
?>
<!DOCTYPE html>
<html>
<head>
    <title>HOD Uploads</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f8;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 90%;
            max-width: 1100px;
            margin: 40px auto;
        }

        .topbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }

        .topbar h2 {
            font-size: 26px;
            color: #333;
            margin: 0;
        }

        .topbar a {
            text-decoration: none;
            background: #4a6cf7;
            color: white;
            padding: 10px 18px;
            border-radius: 8px;
            transition: 0.25s;
        }
        .topbar a:hover {
            background: #2e4ad4;
        }

        .card {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }

        .card h3 {
            margin: 0 0 20px 0;
            font-size: 22px;
            color: #444;
        }

        .item {
            display: flex;
            justify-content: space-between;
            border-bottom: 1px solid #e6e6e6;
            padding: 18px 0;
        }

        .item:last-child {
            border-bottom: none;
        }

        .item strong {
            font-size: 18px;
            color: #222;
        }

        .item span {
            color: #666;
            font-size: 14px;
        }

        .item small {
            color: #999;
        }

        .item a {
            text-decoration: none;
            background: #27ae60;
            color: white;
            padding: 10px 14px;
            border-radius: 7px;
            transition: 0.2s;
        }

        .item a:hover {
            background: #1e8d4d;
        }
    </style>

</head>
<body>

<div class="container">

    <div class="topbar">
        <h2>All HOD Uploads</h2>
        <a href="dashboard.php">Back</a>
    </div>

    <div class="card">
        <h3>Uploaded Tests</h3>

        <?php while ($u = $res->fetch_assoc()): ?>
            <div class="item">
                <div>
                    <strong><?= $u['subject'] ?></strong><br>
                    <span>Teacher: <?= $u['teacher_name'] ?></span><br>
                    <span>Department: <?= $u['department'] ?></span><br>
                    <small>Uploaded: <?= $u['upload_date'] ?></small>
                </div>

                <div>
                    <a href="../hod/hod_download.php?id=<?= $u['upload_id'] ?>">Download</a>
                </div>
            </div>
        <?php endwhile; ?>

    </div>

</div>

</body>
</html>
