<?php
include('../config/db_connect.php');
include('numberwords.php');

$id=$_GET['id'];

$q=mysqli_fetch_assoc(mysqli_query($conn,"
SELECT p.*, e.*
FROM payroll p
JOIN employees e ON e.employee_id = p.employee_id
WHERE p.payroll_id=$id
"));

$net_words = numberToWords($q['net_pay']);
?>
<!DOCTYPE html>
<html>
<head>
<title>Payslip</title>

<style>
body{font-family:Georgia;background:#fff}
.sheet{
    width:900px;
    margin:auto;
    border:1px solid #444;
    padding:20px;
}

.header{text-align:center;margin-bottom:15px;}
.header h2{margin:0}

.data{
    display:flex;
    justify-content:space-between;
}

table{
    width:100%;
    border-collapse:collapse;
    margin-top:10px;
}

td,th{
    border:1px solid black;
    padding:5px;
    text-align:left;
}

.print{
    margin:20px auto;
    text-align:center;
}

@media print{
    .print{display:none}
}
</style>
</head>

<body>

<div class="print">
    <button onclick="window.print()">🖨 PRINT PAYSLIP</button>
    <a href="download_pdf.php?id=<?= $id ?>">⬇ DOWNLOAD PDF</a>
</div>

<div class="sheet">

<div class="header">
<h2>Zambia Manufacturing</h2>
<small>Plot 7182 Industrial Area, Lusaka Zambia</small>
<h4>Payslip for <?= $q['period'] ?></h4>
</div>

<div class="data">
<div>
Employee: <?= $q['full_name'] ?><br>
Dept: <?= $q['department'] ?><br>
Designation: <?= $q['designation'] ?><br>
Joined: <?= $q['date_joined'] ?>
</div>

<div>
Days Worked: <?= $q['days_worked'] ?><br>
TPIN: <?= $q['tpin'] ?><br>
NAPSA No: <?= $q['napsa_no'] ?><br>
Account: <?= $q['bank_account'] ?>
</div>
</div>

<table>
<tr>
<th>EARNINGS</th><th>AMOUNT</th>
<th>DEDUCTIONS</th><th>AMOUNT</th>
</tr>

<tr>
<td>Basic Salary</td>
<td><?= number_format($q['basic_salary'],2) ?></td>

<td>PAYE</td>
<td><?= number_format($q['paye'],2) ?></td>
</tr>

<tr>
<td></td><td></td>
<td>NAPSA</td>
<td><?= number_format($q['napsa'],2) ?></td>
</tr>

<tr>
<td></td><td></td>
<td>NHIMA</td>
<td><?= number_format($q['nhima'],2) ?></td>
</tr>

<tr>
<td></td><td></td>
<td>Other</td>
<td><?= number_format($q['manual_deductions'],2) ?></td>
</tr>

<tr>
<th>Total</th>
<th><?= number_format($q['basic_salary'],2) ?></th>

<th>Total Deduction</th>
<th>
<?= number_format(($q['paye']+$q['napsa']+$q['nhima']+$q['manual_deductions']),2) ?>
</th>
</tr>

<tr>
<th colspan="2">NET PAY</th>
<th colspan="2"><?= number_format($q['net_pay'],2) ?></th>
</tr>
</table>

<p><b>In Words:</b> <?= $net_words ?></p>

<br>
Employer Sign ________________________ &nbsp;&nbsp;
Employee Sign ________________________

</div>

</body>
</html>
