<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

// Fetch teachers with class names
$query = "
    SELECT teachers.teacher_id, teachers.full_name, teachers.username, classes.class_name
    FROM teachers
    LEFT JOIN classes ON teachers.class_id = classes.class_id
    ORDER BY teachers.full_name ASC
";
$result = mysqli_query($conn, $query);
$total_teachers = mysqli_num_rows($result);
?>

<!DOCTYPE html>
<html>
<head>
    <title>View Teachers</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #f1f5f9;
        }

        .container {
            width: 90%;
            margin: 40px auto;
            background: white;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0px 0px 10px rgba(0,0,0,0.12);
        }

        h2 {
            text-align: center;
            color: #075d8a;
            margin-bottom: 18px;
        }

        .count {
            text-align: center;
            font-size: 16px;
            margin-bottom: 12px;
            color: #555;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th, td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            text-align: center;
        }

        th {
            background: #075d8a;
            color: white;
        }

        a.btn {
            padding: 6px 12px;
            border-radius: 5px;
            text-decoration: none;
            color: white;
            font-weight: bold;
        }

        .edit { background: #f4b400; }
        .delete { background: #d9534f; }

        .edit:hover { background: #d99a00; }
        .delete:hover { background: #b52b27; }

        .back {
            display: inline-block;
            margin-top: 25px;
            padding: 10px 18px;
            background: #075d8a;
            color: white;
            border-radius: 6px;
            text-decoration: none;
        }

        .back:hover { background: #0a9edb; }

        .empty {
            text-align: center;
            padding: 18px;
            color: #777;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>🧑‍🏫 Teacher List</h2>
    <div class="count">Total Teachers: <b><?php echo $total_teachers; ?></b></div>

    <?php if($total_teachers > 0) { ?>
    <table>
        <tr>
            <th>Full Name</th>
            <th>Username</th>
            <th>Class Assigned</th>
            <th>Actions</th>
        </tr>

        <?php while($row = mysqli_fetch_assoc($result)) { ?>
            <tr>
                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                <td><?php echo htmlspecialchars($row['username']); ?></td>
                <td><?php echo $row['class_name'] ? htmlspecialchars($row['class_name']) : "<i>Not Assigned</i>"; ?></td>
                <td>
                    <a class="btn edit" href="edit_teacher.php?id=<?php echo $row['teacher_id']; ?>">Edit</a>
                    <a class="btn delete" href="delete_teacher.php?id=<?php echo $row['teacher_id']; ?>" onclick="return confirm('Are you sure you want to delete this teacher?');">Delete</a>
                </td>
            </tr>
        <?php } ?>
    </table>

    <?php } else { ?>
        <p class="empty">No teachers found.</p>
    <?php } ?>

    <a class="back" href="dashboard.php">⬅ Back to Dashboard</a>
</div>

</body>
</html>
