<?php
// hod/hod_dashboard.php
session_start();
include('../config/db_connect.php');

if (!isset($_SESSION['hod_id'])) {
    header("Location: hod_login.php");
    exit;
}

$hod_id = (int)$_SESSION['hod_id'];
$hod_name = $_SESSION['hod_name'] ?? '';
$dept_id = $_SESSION['hod_dept'] ?? null;

// fetch department name if available
$dept_name = '';
if ($dept_id) {
    $d = mysqli_fetch_assoc(mysqli_query($conn, "SELECT dept_name FROM departments WHERE dept_id = ".(int)$dept_id." LIMIT 1"));
    $dept_name = $d ? $d['dept_name'] : '';
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>HOD Dashboard</title>
  <link rel="stylesheet" href="css/hod_style.css">
</head>
<body>
<div class="container">
  <div class="topbar">
    <div class="brand"><h2>HOD Dashboard</h2></div>
    <div class="navlinks">
      <a href="upload_tests.php">Upload Tests</a>
      <a href="hod_logout.php" class="link">Logout</a>
    </div>
  </div>

  <div class="card">
    <h3>Welcome, <?php echo htmlspecialchars($hod_name); ?></h3>
    <p class="small">Department: <?php echo htmlspecialchars($dept_name ?: 'N/A'); ?></p>

    <div style="margin-top:14px" class="info">
      <strong>Quick actions</strong>
      <div style="margin-top:8px">
        <a class="btn" href="upload_tests.php">➕ Upload Tests</a>
        <a class="btn secondary" href="upload_tests.php?view=mine">📄 View My Uploads</a>
      </div>
    </div>
  </div>

  <!-- Recent uploads (last 6) -->
  <div class="card">
    <h4>Recent Uploads</h4>
    <div class="list">
      <?php
      $q = mysqli_query($conn, "SELECT * FROM hod_uploads WHERE hod_id = $hod_id ORDER BY upload_date DESC LIMIT 6");
      if (mysqli_num_rows($q) === 0){
          echo "<p class='small'>No uploads yet. Use Upload Tests to add files.</p>";
      } else {
          while($r = mysqli_fetch_assoc($q)){
              $url = "../uploads/{$r['file_name']}";
              echo "<div class='upload-item'>
                      <div class='upload-meta'>
                        <div><strong>".htmlspecialchars($r['subject'] ?: $r['original_name'])."</strong></div>
                        <div class='small'>".date("d M Y H:i", strtotime($r['upload_date']))."</div>
                      </div>
                      <div>
                      </div>
                    </div>";
          }
      }
      ?>
    </div>
  </div>

</div>
</body>
</html>
