<?php
include('../config/db_connect.php');

if (!isset($_GET['id'])) die("Missing ID");

$id = (int)$_GET['id'];

$stmt = $conn->prepare("SELECT file_name, original_name FROM hod_uploads WHERE upload_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$file = $stmt->get_result()->fetch_assoc();

if (!$file) die("File not found.");

$path = "../" . $file['file_name'];

if (!file_exists($path)) die("File missing on server.");

header("Content-Type: application/octet-stream");
header("Content-Disposition: attachment; filename=\"" . basename($file['original_name']) . "\"");
header("Content-Length: " . filesize($path));

readfile($path);
exit;
