<?php
session_start();
if(!isset($_SESSION['teacher_id'])){
    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Teacher Dashboard</title>

<style>
/* Reset */
*{
    margin:0;
    padding:0;
    box-sizing:border-box;
    font-family:"Poppins", sans-serif;
}

body{
    background:#e8eef5;
}

/* Top Header */
.header{
    width:100%;
    background:linear-gradient(120deg, #0059b3, #0a89ff);
    color:white;
    padding:18px 30px;
    display:flex;
    justify-content:space-between;
    align-items:center;
    box-shadow:0 2px 6px rgba(0,0,0,0.15);
}

.header h2{
    font-size:22px;
    font-weight:600;
}

.logout{
    background:#ff3333;
    padding:10px 16px;
    border-radius:8px;
    color:white;
    text-decoration:none;
    font-weight:600;
    transition:0.2s;
}

.logout:hover{
    background:#cc0000;
}

/* Main container */
.container{
    width:95%;
    max-width:1000px;
    margin:40px auto;
}

/* Center white card */
.dashboard-box{
    background:white;
    padding:30px;
    border-radius:12px;
    box-shadow:0 3px 8px rgba(0,0,0,0.1);
    text-align:center;
}

/* Title */
.dashboard-box h1{
    font-size:26px;
    color:#0059b3;
    font-weight:600;
    margin-bottom:20px;
}

/* Grid of tiles */
.menu-grid{
    display:grid;
    grid-template-columns: repeat(auto-fit, minmax(210px, 1fr));
    gap:20px;
    margin-top:25px;
}

/* Menu tiles */
.tile{
    background:#f5f8ff;
    border:2px solid #d6e4ff;
    padding:25px;
    border-radius:12px;
    text-decoration:none;
    color:#003d80;
    font-size:17px;
    font-weight:600;
    transition:0.25s;
    box-shadow:0 2px 6px rgba(0,0,0,0.08);
}

.tile:hover{
    background:#0a89ff;
    color:white;
    border-color:#0a89ff;
    transform:translateY(-4px);
}

/* Responsive */
@media(max-width:600px){
    .dashboard-box h1{
        font-size:22px;
    }
}
</style>
</head>

<body>

<div class="header">
    <h2>Teacher Dashboard</h2>
    <a href="logout.php" class="logout">Logout</a>
</div>

<div class="container">
    <div class="dashboard-box">

        <h1>Welcome, <?php echo $_SESSION['teacher_name']; ?> 👋</h1>

        <div class="menu-grid">

            <a class="tile" href="manage_subjects.php">📚 Manage Subjects</a>
            <a class="tile" href="enter_marks.php">✏️ Enter Marks</a>
            <a class="tile" href="report_card.php">📄 View Results</a>
            <a class="tile" href="manage_students.php">👨‍🎓 Manage Students</a>
            <a class="tile" href="upload_students.php">➕ Upload Students</a>

        </div>

    </div>
</div>

</body>
</html>
