<?php
session_start();
include('../config/db_connect.php');

$error = "";

if ($_SERVER['REQUEST_METHOD'] == "POST") {

    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    // Prevent SQL Injection
    $stmt = $conn->prepare("SELECT teacher_id, full_name, class_id, password FROM teachers WHERE username = ? LIMIT 1");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if user exists
    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();

        // Compare plain text password
        if ($password === $user['password']) {
            $_SESSION['teacher_id'] = $user['teacher_id'];
            $_SESSION['teacher_name'] = $user['full_name'];
            $_SESSION['class_id'] = $user['class_id'];

            header("Location: dashboard.php");
            exit;
        } else {
            $error = "Incorrect password!";
        }
    } else {
        $error = "Username not found!";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Teacher Login</title>
    <style>
        body {
            font-family: Arial;
            background: #f2f6ff;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh; margin: 0;
        }
        .login-box {
            background: #fff;
            width: 350px;
            padding: 35px;
            border-radius: 12px;
            box-shadow: 0px 6px 20px rgba(0,0,0,0.1);
            text-align: center;
        }
        input, button {
            width: 100%; padding: 12px; margin: 10px 0;
            border-radius: 8px; font-size: 15px;
        }
        input { border: 1px solid #ccc; }
        button {
            background: #2b3a67; color: #fff;
            border: none; cursor: pointer; transition:.3s;
        }
        button:hover { background: #1e2950; }
        .error { color: red; margin-top: 10px; }
        .back-btn {
            display:block; margin-top:10px;
            text-decoration:none; color:#2b3a67;
            font-size:14px; font-weight:bold;
        }
    </style>
</head>
<body>

<div class="login-box">
    <h2>Teacher Login</h2>

    <form method="POST">
        <input type="text" name="username" placeholder="Enter Username" required>
        <input type="password" name="password" placeholder="Enter Password" required>
        <button type="submit">Login</button>
    </form>

    <a href="../index.php" class="back-btn">⬅ Back to Home</a>

    <?php if(!empty($error)) { echo "<p class='error'>$error</p>"; } ?>
</div>

</body>
</html>
