<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['teacher_id'])){
    header("Location: index.php");
    exit;
}

$class_id = $_SESSION['class_id']; // Teacher's class only

// Add subject
if(isset($_POST['add_subject'])){
    $subject = mysqli_real_escape_string($conn, $_POST['subject_name']);

    // Prevent duplicates
    $check = mysqli_query($conn, "SELECT * FROM subjects WHERE subject_name='$subject' AND class_id='$class_id'");
    if(mysqli_num_rows($check) > 0){
        echo "<script>alert('Subject already exists for this class!');</script>";
    } else {
        mysqli_query($conn, "INSERT INTO subjects (subject_name, class_id) VALUES ('$subject', '$class_id')");
        echo "<script>alert('Subject Added Successfully!'); window.location='manage_subjects.php';</script>";
    }
}

// Delete subject
if(isset($_GET['delete'])){
    $sub_id = $_GET['delete'];

    mysqli_query($conn, "DELETE FROM subjects WHERE subject_id='$sub_id' AND class_id='$class_id'");
    echo "<script>alert('Subject Removed!'); window.location='manage_subjects.php';</script>";
}

// Fetch list
$subjects = mysqli_query($conn, "SELECT * FROM subjects WHERE class_id='$class_id' ORDER BY subject_name ASC");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Manage Subjects</title>
    <style>
        body { font-family: Arial; }
        .container { width: 90%; margin: auto; margin-top: 30px; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #555; padding: 8px; text-align: center; }
        th { background: #0a4c75; color: white; }
        .form-box { margin-top: 20px; border:1px solid #ccc; padding:15px; width:40%; }
        input, button { padding: 8px; width:100%; }
        button { background:#0078ff; color:#fff; border:none; }
    </style>
</head>
<body>

<div class="container">

    <h2>Subjects for Your Class</h2>

    <table>
        <tr>
            <th>#</th>
            <th>Subject Name</th>
            <th>Action</th>
        </tr>

        <?php $i=1; while($row = mysqli_fetch_assoc($subjects)){ ?>
        <tr>
            <td><?php echo $i++; ?></td>
            <td><?php echo strtoupper($row['subject_name']); ?></td>
            <td><a href="?delete=<?php echo $row['subject_id']; ?>" onclick="return confirm('Delete this subject?');">❌ Remove</a></td>
        </tr>
        <?php } ?>
    </table>

    <div class="form-box">
        <h3>Add New Subject</h3>
        <form method="POST">
            <label>Subject Name:</label><br>
            <input type="text" name="subject_name" required placeholder="e.g. Mathematics"><br><br>
            <button type="submit" name="add_subject">Add Subject</button>
        </form>
    </div>

    <br><br>
    <a href="dashboard.php">⬅ Back to Dashboard</a>

</div>

</body>
</html>
