<?php
session_start();
include('../config/db_connect.php');

// Ensure teacher logged in
if(!isset($_SESSION['teacher_id'])){
    die("Access denied. Please log in.");
}

$teacher_id = $_SESSION['teacher_id'];
$term = isset($_GET['term']) ? $_GET['term'] : "Term 1";

// Fetch teacher info
$teacher_row = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM teachers WHERE teacher_id='$teacher_id'"));
if(!$teacher_row) die("Teacher not found.");
$class_id = $teacher_row['class_id'];

// Class info
$class = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM classes WHERE class_id='$class_id'"));
$className = $class ? $class['class_name'] : "N/A";

// Fetch all students for this class
$students_res = mysqli_query($conn, "SELECT * FROM students WHERE class_id='$class_id' ORDER BY full_name ASC");
$total_students = mysqli_num_rows($students_res);

// Build array of averages for ranking
$averages = [];
while($s = mysqli_fetch_assoc($students_res)){
    $sid = $s['student_id'];
    $avg_row = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT AVG(IFNULL(mark,0)) AS avgMark 
        FROM marks 
        WHERE student_id='$sid' AND term='".mysqli_real_escape_string($conn,$term)."'
    "));
    $avg = $avg_row && $avg_row['avgMark'] ? round($avg_row['avgMark'], 2) : 0;
    $averages[$sid] = $avg;
}

// Sort descending by average
arsort($averages);

// Generate rank array
$ranks = [];
$rank = 1;
$prevAvg = null;
$ties = 0;

foreach($averages as $sid => $avg){
    if($prevAvg !== null && $avg == $prevAvg){
        $ties++;
    } else {
        $rank += $ties;
        $ties = 0;
    }
    $ranks[$sid] = $rank;
    $prevAvg = $avg;
    $rank++;
}

// Grading function
function grade_info($m){
    if($m >= 75) return ["1","DISTINCTION"];
    if($m >= 70) return ["2","DISTINCTION"];
    if($m >= 65) return ["3","MERIT"];
    if($m >= 60) return ["4","MERIT"];
    if($m >= 55) return ["5","CREDIT"];
    if($m >= 50) return ["6","CREDIT"];
    if($m >= 45) return ["7","SATISFACTORY"];
    if($m >= 40) return ["8","SATISFACTORY"];
    return ["9","UNSATISFACTORY"];
}

// Re-fetch students for display
$students_q = mysqli_query($conn, "SELECT * FROM students WHERE class_id='$class_id' ORDER BY full_name ASC");
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Class Report Cards - <?php echo htmlspecialchars($className); ?></title>
<style>
    body{font-family: Arial, sans-serif; background:#fff; color:#111; margin:20px;}
    .page{max-width:800px;margin:auto;border:1px solid #ddd;padding:18px;page-break-after:always;}
    .header{display:flex;align-items:center;justify-content:space-between;margin-bottom:14px;}
    .logo{width:70px;height:70px;}
    .school-title{text-align:center;}
    h1{margin:0;font-size:20px;}
    .sub{font-size:13px;margin-top:4px;}
    .meta{display:flex;justify-content:space-between;margin-top:17px;}
    .meta div{width:56%;}
    table{width:100%;border-collapse:collapse;margin-top:12px;}
    th,td{border:1px solid #000;padding:6px;text-align:center;font-size:13px;}
    th{background:#dff0d8;}
    .signs{display:flex;justify-content:space-between;margin-top:18px;}
    .sign-box{width:30%;text-align:center;}
    .sign-line{border:1px solid #000;height:60px;margin-bottom:6px;}
    .print-btn{background:#075d8a;color:#fff;padding:8px 12px;border:none;border-radius:6px;cursor:pointer;}
    @media print{ .print-btn, .term-select{display:none} }
    .term-select{margin-bottom:20px;}
</style>
</head>
<body>

<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:15px;">
    <form method="get" class="term-select">
        <label for="term"><strong>Select Term:</strong></label>
        <select name="term" id="term" onchange="this.form.submit()">
            <option value="Term 1" <?php if($term=="Term 1") echo "selected"; ?>>Term 1</option>
            <option value="Term 2" <?php if($term=="Term 2") echo "selected"; ?>>Term 2</option>
            <option value="Term 3" <?php if($term=="Term 3") echo "selected"; ?>>Term 3</option>
        </select>
    </form>

    <button class="print-btn" onclick="window.print()">🖨️ Print All</button>
</div>

<?php
while($student = mysqli_fetch_assoc($students_q)){
    $student_id = $student['student_id'];

    // Get marks for term
    $marks_q = mysqli_query($conn, "
        SELECT s.subject_name, m.mark
        FROM marks m
        LEFT JOIN subjects s ON m.subject_id = s.subject_id
        WHERE m.student_id='$student_id' AND m.term='".mysqli_real_escape_string($conn,$term)."'
        ORDER BY s.subject_name ASC
    ");

    // Average + passed
    $avg_row = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT AVG(IFNULL(mark,0)) AS avgMark, SUM(IF(mark>=40,1,0)) AS passedCount, COUNT(*) AS subjCount
        FROM marks
        WHERE student_id='$student_id' AND term='".mysqli_real_escape_string($conn,$term)."'
    "));
    $average = $avg_row && $avg_row['avgMark'] !== null ? round($avg_row['avgMark'], 2) : 0;
    $passedCount = $avg_row ? (int)$avg_row['passedCount'] : 0;
    $subjCount = $avg_row ? (int)$avg_row['subjCount'] : 0;

    // Get auto rank
    $rank_position = isset($ranks[$student_id]) ? $ranks[$student_id] : "N/A";

    // Performance comment
    if($passedCount == 0) $comment = "Poor performance. Needs serious improvement.";
    elseif($passedCount <= 2) $comment = "Below average performance. More commitment required.";
    elseif($passedCount <= 4) $comment = "Fair performance. Encourage more effort.";
    elseif($passedCount <= 6) $comment = "Good performance. Keep it up.";
    elseif($passedCount <= 8) $comment = "Very good performance. Continue maintaining this level.";
    else $comment = "Excellent performance! Outstanding achievement.";
?>

<div class="page">
    <div class="header">
        <img src="../assets/school_logo.png" alt="logo" class="logo" onerror="this.style.display='none'">
        <div class="school-title">
            <h1>DIVINE PROVIDENCE CONVENT SCHOOL</h1>
            <div class="sub">P.O BOX 214, CHAWAMA - LUSAKA · PHONE: +260 773398030</div>
            <div style="margin-top:8px;font-weight:bold;">REPORT CARD - <?php echo htmlspecialchars($term); ?></div>
        </div>
        <img src="../assets/coat.png" alt="logo2" class="logo" onerror="this.style.display='none'">
    </div>

    <div class="meta">
        <div>
            <div><strong>Pupil's Name:</strong> <?php echo htmlspecialchars($student['full_name']); ?></div>
            <div><strong>Gender:</strong> <?php echo htmlspecialchars($student['gender']); ?></div>
            <div><strong>Class Teacher:</strong> <?php echo htmlspecialchars($teacher_row['full_name']); ?></div>
        </div>
        <div>
            <div><strong>Grade:</strong> <?php echo htmlspecialchars($className); ?></div>
            <div><strong>Date:</strong> <?php echo date("d/m/Y"); ?></div>
            <div><strong>Subjects Recorded:</strong> <?php echo $subjCount; ?></div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>SUBJECT</th>
                <th>TOTAL MARKS</th>
                <th>MARKS OBTAINED (%)</th>
                <th>GRADE</th>
                <th>STANDARD</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $count = 0;
            while($r = mysqli_fetch_assoc($marks_q)){
                $count++;
                $mval = is_null($r['mark']) ? 0 : (int)$r['mark'];
                list($g,$std) = grade_info($mval);
                echo "<tr>
                        <td style='text-align:left;padding-left:8px;'>".htmlspecialchars(strtoupper($r['subject_name']))."</td>
                        <td>100</td>
                        <td>{$mval}</td>
                        <td>{$g}</td>
                        <td>{$std}</td>
                    </tr>";
            }
            if($count === 0){
                echo "<tr><td colspan='5'>No marks recorded for this term.</td></tr>";
            }
            ?>
        </tbody>
    </table>

    <div style="margin-top:12px;">
        <strong>AVERAGE MARK:</strong> <?php echo $average; ?>% &nbsp;&nbsp;&nbsp;
        <strong>SUBJECTS PASSED:</strong> <?php echo $passedCount; ?>/<?php echo $subjCount; ?> &nbsp;&nbsp;&nbsp;
        <strong>CLASS POSITION:</strong> <?php echo "{$rank_position} out of {$total_students}"; ?>
    </div>

    <h4 style="margin-top:14px;">PERFORMANCE COMMENT:</h4>
    <p><?php echo htmlspecialchars($comment); ?></p>

    <div class="signs">
        <div class="sign-box">
            <div class="sign-line"></div>
            <div>Class Teacher</div>
            <div style="margin-top:6px;"><?php echo htmlspecialchars($teacher_row['full_name']); ?></div>
        </div>
        <div class="sign-box">
            <div class="sign-line"></div>
            <div>Deputy Head</div>
            <div style="margin-top:6px;">Mr Tembo</div>
        </div>
        <div class="sign-box">
            <div class="sign-line"></div>
            <div>Parent / Guardian</div>
            <div style="margin-top:6px;">Parent / Guardian</div>
        </div>
    </div>
</div>

<?php } // end while ?>
</body>
</html>
